<?php
class Repuesto {
    private $db;
    public function __construct()
    {
        $this->db = new Database;
    }

    public function Prod_Paridad(){
    $this->db->query('SELECT * from vta_paridad order by created_at desc limit 0,30');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Prod_categorias(){
    $this->db->query('SELECT * from vta_categorias order by categoria');
    $result = $this->db->resultSet();
    return $result;
    }
	
	public function Prod_caracteristicas($id){
    $this->db->query('SELECT * from vta_caracteristicas where id_categoria= :id');
	 $this->db->bind(':id', $id);
    $result = $this->db->resultSet();
    return $result;
    }

	
	public function Prod_caracteristicasBuc($id){
    $this->db->query('SELECT * from vta_prod_caract where codigo= :id');
	 $this->db->bind(':id', $id);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Prod_caracteristicasGral(){
    $this->db->query('SELECT * from vta_prod_caract order by codigo,caracteristicas');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Prod_Gral(){
 	$this->db->query('SELECT vta_repuestos.*,vta_categorias.categoria
    FROM (vta_repuestos INNER JOIN vta_categorias ON vta_repuestos.codigo_cat = vta_categorias.codigo) order by vta_categorias.categoria,vta_repuestos.repuesto');

	$result = $this->db->resultSet();
    return $result;
    }

     public function Prod_Gral_Busq($dataa){
        $v1=$dataa['busca'];
        $v2=$dataa['busqueda'];
        $qry= "SELECT * from vta_repuestos where ".$v1." like '%".$v2."%' order by nombre";
        $this->db->query($qry);
    $result = $this->db->resultSet();
    return $result;
    }

    public function countPro_Busq($dataa){
        $v1=$dataa['busca'];
        $v2=$dataa['busqueda'];
        $qry= "SELECT * from vta_repuestos where ".$v1." like '%".$v2."%' order by nombre";
        $this->db->query($qry);
        $result = $this->db->resultSet();
        //check the row
        return $this->db->rowCount();
    }

    public function Prod_Actualiza($data){
        $NRO=encrypt_decrypt('decrypt',$data['_token_id']);
//var_dump($data);
//echo $NRO;
//exit;


        $this->db->query('UPDATE vta_repuestos SET codigo_cat=:codigo_cat,repuesto=:repuesto,detalle=:detalle,medida=:medida,existencia=:existencia WHERE id=:id');
        $this->db->bind(':id', $NRO);
        $this->db->bind(':codigo_cat', $data['categoria']);
        $this->db->bind(':repuesto', trim($data['repuesto']));
        $this->db->bind(':detalle', $data['detalle']);
        $this->db->bind(':existencia', $data['existencia']);
        $this->db->bind(':medida', $data['medida']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function Prod_ActualizaCat($data){
        $this->db->query('UPDATE vta_categorias SET categoria=:nombre WHERE id=:id');
        $this->db->bind(':id', $data['id']);
        $this->db->bind(':nombre', $data['nombre']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }


    public function Prod_GuardarPar($data){
        $this->db->query('INSERT INTO vta_paridad (valor) VALUES (:valor)');
        $this->db->bind(':valor', $data['valor']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function Prod_GuardarCat($data){
        $this->db->query('INSERT INTO vta_categorias (codigo,categoria) VALUES (:cod,:cat)');
        $this->db->bind(':cod', $data['cod']);
		$this->db->bind(':cat', $data['cat']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }
	
	
    public function Prod_GuardarCarac($data,$datacat){

//var_dump($datacat);
//exit;
        $this->db->query('INSERT INTO vta_caracteristicas (id_categoria,caracteristicas) VALUES (:cod,:cat)');
        $this->db->bind(':cod', $data['cod']);
		$this->db->bind(':cat', $data['cat']);
        $id_rec = $this->db->executelast();


        $this->db->query('INSERT INTO vta_prod_caract(codigo,id_caract,caracteristicas,valor) VALUES (:codigo, :id_caract, :caracteristicas, :valor)');
        foreach ($datacat as $p0){
        $this->db->bind(':codigo', $p0->codigo);
        $this->db->bind(':id_caract', $id_rec);
        $this->db->bind(':caracteristicas', $data['cat']);
        $this->db->bind(':valor', '');
        $this->db->execute();
        }
    return true;
    }
	
    public function Prod_Guardar($data){
        $this->db->query('INSERT INTO vta_repuestos (codigo,codigo_cat,repuesto,detalle,existencia,medida)
        VALUES (:codigo, :codigo_cat, :repuesto, :detalle, :existencia,:medida)');
        $this->db->bind(':codigo', strtoupper(trim($data['codigo'])));
        $this->db->bind(':codigo_cat', $data['categoria']);
        $this->db->bind(':repuesto', trim($data['repuesto']));
        $this->db->bind(':detalle', $data['detalle']);
        $this->db->bind(':existencia', $data['existencia']);
        $this->db->bind(':medida', $data['medida']);
       //execute
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }


    public function Prod_BuscarId($id){
        $this->db->query('SELECT * FROM vta_repuestos WHERE id= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }

    public function Prod_BuscarIdCat($id){
        $this->db->query('SELECT codigo FROM vta_repuestos WHERE codigo_cat= :id ');
        $this->db->bind(':id', $id);
        //$row = $this->db->single();
        $result = $this->db->resultSet();
        return $result;
    }

    public function Prod_BuscarIdCat2($id){
        $this->db->query('SELECT vta_repuestos.*,vta_categorias.categoria
        FROM (vta_repuestos INNER JOIN vta_categorias ON vta_repuestos.codigo_cat = vta_categorias.codigo)  WHERE codigo_cat= :id order by vta_categorias.categoria,vta_repuestos.repuesto');
        $this->db->bind(':id', $id);
        $result = $this->db->resultSet();
        return $result;
    }

    public function Prod_BuscarParCodId($id){
        $this->db->query('SELECT * FROM vta_repuestos WHERE codigo= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }
    public function Prod_BuscarCatCodId($id,$cat){
        $this->db->query('SELECT * FROM vta_repuestos WHERE codigo= :id and codigo_cat=:cat ');
        $this->db->bind(':id', $id);
        $this->db->bind(':cat', $cat);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }

    public function Prod_BuscarPar(){
        $this->db->query('SELECT * FROM vta_paridad  order by created_at desc limit 0,1');
        $row = $this->db->single();
        return $row;
    }

    public function Prod_BuscarCodId($id){
        $this->db->query('SELECT * FROM vta_repuestos WHERE codigo= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }
    public function Prod_Buscar($id){
        $this->db->query('SELECT * FROM vta_repuestos WHERE rif= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return 'NOPUEDEBORRAR';
        }else{
        return true;
        }
    }

    public function Prod_BuscarCod($id){
        $this->db->query('SELECT * FROM vta_repuestos WHERE codigo= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return false;
        }else{
        return true;
        }
    }


    public function Prod_BuscarCatId($id){
        $this->db->query('SELECT * FROM vta_categorias WHERE id= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }

   //delete a post


    public function countPro(){
//        $idCond=$_SESSION['id_edif'];
        $this->db->query('SELECT id FROM vta_repuestos');
//        $this->db->bind(':idCond', $idCond);
        $result = $this->db->resultSet();

        //check the row
        return $this->db->rowCount();
    }

    public function getMEDIDA(){
        $this->db->query('SELECT * FROM vta_medidas order by medida');
        $result = $this->db->resultSet();
        //check the row
        return $result;
    }

    public function sumaPro(){
        $this->db->query('SELECT SUM(nombre) as sumapro FROM vta_repuestos');
        return $this->db->rowSuma();
    }

    public function pagoPro($data){
        $this->db->query('INSERT INTO pagos(id_inmueble,fecha,forma,detalle,documento,banco,monto,nota_credito_n,nota_credito_p)
        VALUES (:id_inmueble, :fecha, :pago, :detalle, :documento, :banco, :monto, :nota_cr, :nota_cr0)');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':pago', $data['pago']);
        $this->db->bind(':detalle', $data['detalle']);
        $this->db->bind(':documento', $data['documento']);
        $this->db->bind(':banco', $data['banco']);
        $this->db->bind(':monto', $data['monto']);
        $this->db->bind(':nota_cr', $data['nota_cr']);
        $this->db->bind(':nota_cr0', $data['nota_cr0']);
        //execute
        $id_rec = $this->db->executelast();

        if($data['nota_cr']>0){
        $this->db->query('INSERT INTO pagos_nc(id_pago,id_inmueble,fecha,monto)
        VALUES (:id_pago, :id_inmueble, :fecha, :monto)');
        $this->db->bind(':id_pago', $id_rec);
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':monto', $data['nota_cr']);
        //execute
        $this->db->execute();

        $this->db->query('UPDATE propietarios SET saldo=saldo- :saldo, nota_credito= :monto WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':monto', $data['nota_cr']);
        $this->db->bind(':saldo', $data['monto']);
        //execute
        $this->db->execute();
        }else{
        $this->db->query('UPDATE propietarios SET recibos=recibos-1,saldo=saldo- :saldo, nota_credito=0 WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':saldo', $data['monto']); 
        //execute
        $this->db->execute();
        }
        return $id_rec;
    }

    public function deletePro($id){
        $idCond=$_SESSION['id_edif'];
        $this->db->query('DELETE FROM propietarios WHERE id_edificio= :idCond and inmueble = :id');
        $this->db->bind(':id', $id);
        $this->db->bind(':idCond', $idCond);
        if($this->db->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function deletecaract($id){
        $this->db->query('DELETE FROM vta_caracteristicas WHERE id = :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
            return true;
        }else{
            return false;
        }
    }
}